/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.mediasvc;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.util.Trace;
import java.io.FileInputStream;
import java.util.Properties;

class MediaServicesParameters {
    private static final String TRACE_MASKT = "XMDAMSPT";
    private static final String TRACE_MASKF = "XMDAMSPF";
    private static final String TRACE_MASKD = "XMDAMSPD";
    private static MediaServicesParameters mediaServicesParameters;
    private Properties mediaServicesProperties = new Properties();

    private MediaServicesParameters() {
        Trace.trace(TRACE_MASKT, "-> MediaServicesParameters.MediaServicesParameters()");
        FileInputStream propertiesFileInputStream = null;
        this.mediaServicesProperties = new Properties();
        try {
            String fileName = BaseFileControl.getFilePath("media.properties") + "media.properties";
            Trace.trace(TRACE_MASKD, "MediaServicesParameters.MediaServicesParameters(): fileName = " + fileName);
            propertiesFileInputStream = new FileInputStream(fileName);
            this.mediaServicesProperties.load(propertiesFileInputStream);
            propertiesFileInputStream.close();
            this.mediaServicesProperties.put("media.log.dir", BaseFileControl.getFilePath("tmp") + "mediasvc/");
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
            this.mediaServicesProperties.put("media.mount.script", "mountmedia.sh");
            this.mediaServicesProperties.put("media.unmount.script", "unmountmedia.sh");
            this.mediaServicesProperties.put("media.df.script", "rundf.sh");
            this.mediaServicesProperties.put("media.log", "mediasvcs.log");
            this.mediaServicesProperties.put("media.log.dir", "/tmp/console/mediasvc/");
            this.mediaServicesProperties.put("media.eject.script", "ejectmedia.sh");
            this.mediaServicesProperties.put("media.number.device.types", "4");
            this.mediaServicesProperties.put("media.device.properties", "devices/");
            this.mediaServicesProperties.put("media.device.file.script", "devicefile.sh");
            this.mediaServicesProperties.put("media.device.check.media.script", "checkmedia.sh");
            this.mediaServicesProperties.put("media.device.lockdoor", "lockdoor");
            this.mediaServicesProperties.put("media.device.unlockdoor", "unlockdoor");
            this.mediaServicesProperties.put("media.device.lock.script", "lockdevicedoor.sh");
            this.mediaServicesProperties.put("media.hd.partition.info", "hd.partitions");
            this.mediaServicesProperties.put("media.disketteformat.script", "disketteformat.sh");
            this.mediaServicesProperties.put("media.dvdformat.script", "dvdformat.sh");
            this.mediaServicesProperties.put("media.usbmemformat.script", "usbmemformat.sh");
            this.mediaServicesProperties.put("media.device.detect.script", "detectdevices.sh");
        }
        Trace.trace(TRACE_MASKT, "<- MediaServicesParameters.MediaServicesParameters()");
    }

    static synchronized MediaServicesParameters getMediaServicesParameters() {
        Trace.trace(TRACE_MASKT, "-> MediaServicesParameters.getMediaServicesParameters()");
        if (mediaServicesParameters == null) {
            mediaServicesParameters = new MediaServicesParameters();
        }
        Trace.trace(TRACE_MASKT, "<- MediaServicesParameters.getMediaServicesParameters()");
        return mediaServicesParameters;
    }

    String getParm(String parameter) {
        Trace.trace(TRACE_MASKT, "<> MediaServicesParameters.getParm(" + parameter + ")");
        return this.mediaServicesProperties.getProperty(parameter);
    }
}

